// the evo sword, yes this ruins pvp, go away. jason-

using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
    public class BowOfEvolution : CompositeBow
    {

        public override int EffectID { get { return 0xF42; } }
        public override Type AmmoType { get { return typeof(Arrow); } }
        public override Item Ammo { get { return new Arrow(); } }

        public override WeaponAbility PrimaryAbility { get { return WeaponAbility.ArmorIgnore; } }
        public override WeaponAbility SecondaryAbility { get { return WeaponAbility.MovingShot; } }

        private int mEvolutionPoints = 0;

        [CommandProperty(AccessLevel.GameMaster)]
        public int EvolutionPoints { get { return mEvolutionPoints; } set { mEvolutionPoints = value; } }

        public override int ArtifactRarity { get { return 500; } }

        public override int InitMinHits { get { return 255; } }
        public override int InitMaxHits { get { return 255; } }

        [Constructable]
        public BowOfEvolution()
        {
            Name = "Bow Of Evolution";
            Hue = 1161;
            WeaponAttributes.UseBestSkill = 1;

            Attributes.Luck = 100;

            Attributes.WeaponDamage = 1;
            Attributes.WeaponSpeed = 10;
            Attributes.SpellChanneling = 1;
        }

        public BowOfEvolution(Serial serial)
            : base(serial)
        {
        }
        
		public override bool OnEquip( Mobile from )
		{
			if ( from is PlayerMobile )
            this.BlessedFor = from;
         else if ( from is BaseCreature && ((BaseCreature)from).ControlMaster != null )
               this.BlessedFor = ((BaseCreature)from).ControlMaster;
               
         this.InvalidateProperties();
			return base.OnEquip( from );							
		}
		
        public override void OnHit(Mobile attacker, Mobile defender, double Damagebonus)
        {
            if ( SwordOfEvolution.ApplyGain( attacker, defender, this, ref mEvolutionPoints ) )
               this.Name = "Bow Of Evolution (" + mEvolutionPoints.ToString() + ")";

            base.OnHit(attacker, defender,Damagebonus);
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)2);
            writer.Write(mEvolutionPoints);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
            mEvolutionPoints = reader.ReadInt();
            
            if ( version == 0 && mEvolutionPoints == 10001 )
               mEvolutionPoints = 10000;
               
            if ( version == 1 && mEvolutionPoints == 10001 )
            {
               this.MinDamage = AOS.Scale( this.MinDamage, 130 );
               this.MaxDamage = AOS.Scale( this.MaxDamage, 130 );
            }
        }
    }
}